/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.dialog.IpAddressListPanel;
import DE.siemens.ad.logo.dialog.comp.IPAddressJTextField;
import DE.siemens.ad.logo.model.EthernetConnection;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.SOutputParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.panel.BlockParameterPanel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SOutputPanel
extends BlockParameterPanel {
    protected JPanel fSlavePanel;
    private IPAddressJTextField fSlaveAddress;
    protected JComboBox fOutputList;
    protected SOutputParameter fParameter;
    private WiringDiagram fWiringDiagram;
    protected JLabel fOutputLabel;

    public SOutputPanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
        this.fParameter = (SOutputParameter)this.fParameterReference;
        this.fWiringDiagram = this.fParameter.getBlock().getWiringDiagram();
        JPanel container = new JPanel(new FlowLayout(0));
        container.add(this.getSlavePanel());
        this.addParameterPane(container);
    }

    protected JPanel getSlavePanel() {
        if (this.fSlavePanel == null) {
            this.fSlavePanel = new JPanel(new GridBagLayout());
            this.fSlaveAddress = new IPAddressJTextField();
            String lastIP = this.fParameter.getBlock().getWiringDiagram().getLastEditableIPAddress();
            if (!"".equals(lastIP)) {
                this.fSlaveAddress.setIP(lastIP);
            }
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 2;
            constraints.anchor = 18;
            constraints.insets = new Insets(2, 0, 4, 4);
            constraints.gridx = 0;
            constraints.gridy = 0;
            this.fSlavePanel.add((Component)new JLabel(Language.getString("block.NetworkNode.slaveIP", "Slave IP:")), constraints);
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.insets = new Insets(0, 0, 4, 4);
            this.fSlavePanel.add((Component)this.fSlaveAddress, constraints);
            constraints.insets = new Insets(2, 0, 0, 0);
            constraints.gridx = 2;
            constraints.gridy = 0;
            JButton button1 = new JButton("...");
            button1.setPreferredSize(new Dimension(20, 18));
            button1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IpAddressListPanel addressListsPanel = new IpAddressListPanel();
                    addressListsPanel.setPreferredSize(new Dimension(240, 165));
                    SplittedDlg dialog = SplittedDlg.create(null, addressListsPanel, 3);
                    dialog.setTitle(Language.getString("panel.networkNodePanel.ipAddressList.title", "IP Addresses List"));
                    dialog.show();
                    if (dialog.getControlPanel().getResult() != 1) {
                        return;
                    }
                    SOutputPanel.this.fSlaveAddress.setIP(addressListsPanel.getSelectedIPAddress());
                }
            });
            this.fSlavePanel.add((Component)button1, constraints);
            constraints.gridx = 3;
            constraints.gridy = 0;
            this.fSlavePanel.add((Component)new JPanel(), constraints);
            constraints.gridx = 0;
            constraints.gridy = 1;
            this.fOutputLabel = new JLabel(Language.getString("block.Output", "Output") + ":");
            this.fSlavePanel.add((Component)this.fOutputLabel, constraints);
            constraints.gridx = 1;
            constraints.gridy = 1;
            this.fSlavePanel.add((Component)this.getSlaveOutputList(), constraints);
        }
        return this.fSlavePanel;
    }

    private JComboBox getSlaveOutputList() {
        if (this.fOutputList == null) {
            this.fOutputList = new JComboBox();
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
            for (int i = 1; i <= this.getMaxResource(); ++i) {
                model.addElement(this.fParameter.getConfiguredBlockPrefix() + i);
            }
            this.fOutputList.setModel(model);
        }
        return this.fOutputList;
    }

    protected int getMaxResource() {
        return this.fParameter.getBlock().getHardware().getMaxResource(7);
    }

    public void loadFieldContents() {
        if (!"".equals(this.fParameter.getAddress())) {
            this.fSlaveAddress.setIP(this.fParameter.getAddress());
        }
        this.fOutputList.setSelectedIndex(this.fParameter.getConfiguredBlockNumber() - 1);
    }

    public boolean checkFieldContents() {
        if (!this.checkChanged()) {
            return true;
        }
        if (this.fSlaveAddress.getIP().equals("")) {
            new LogoError(Language.getString("panel.networkNodePanel.emptySlaveAddress", "You must enter a slave address. otherwise this block will not work.")).display();
            return false;
        }
        if (this.isClientServerConflict(this.fSlaveAddress.getIP())) {
            new LogoError(null, "ethernet.ethernetConfigurePanel.clientServerConflict", "You can not specify an IP address as both client and server, \nPlease choose another IP address.", 2, 0).display();
            return false;
        }
        if (this.fOutputList.getSelectedItem() == null) {
            new LogoError(Language.getString("block.NetworkNode.selectBlockNumber", "Please choose a block number")).display();
            return false;
        }
        return this.fWiringDiagram.verifyConnResource(this.fParameter, this.fSlaveAddress.getIP(), this.fParameter.getConfiguredBlockType(), this.fOutputList.getSelectedIndex() + 1, true);
    }

    private boolean isClientServerConflict(String ip) {
        for (EthernetConnection conn : this.fParameter.getBlock().getWiringDiagram().getNetworkInfo().getEthernetConnections()) {
            if (conn.isForSlave() || !ip.equals(conn.getRemoteIP())) continue;
            return true;
        }
        return false;
    }

    public boolean checkChanged() {
        if (!this.fParameter.getAddress().equals(this.fSlaveAddress.getIP()) || this.fParameter.getConfiguredBlockNumber() != this.fOutputList.getSelectedIndex() + 1) {
            return true;
        }
        return super.checkChanged();
    }

    public void storeFieldContents() {
        this.fParameter.setAddress(this.fSlaveAddress.getIP());
        this.fParameter.setConfiguredBlockNumber(this.fOutputList.getSelectedIndex() + 1);
        this.fParameter.getBlock().getWiringDiagram().setLastEditableIPAddress(this.fSlaveAddress.getIP());
    }
}

